// PageSettingProtocol.cpp : implementation file
//

#include "stdafx.h"
#include "NetDecoder.h"
#include "PageSettingProtocol.h"
#include "Include\CLS_NVDSDK_Interface.h"
#include "Include\CommonFun.h"


// CPageSettingProtocol dialog

IMPLEMENT_DYNAMIC(CPageSettingProtocol, CDialog)

CPageSettingProtocol::CPageSettingProtocol(CWnd* pParent /*=NULL*/)
	: CLS_CBasePage(CPageSettingProtocol::IDD, pParent)
{

}

CPageSettingProtocol::~CPageSettingProtocol()
{
}

void CPageSettingProtocol::DoDataExchange(CDataExchange* pDX)
{
	CDialog::DoDataExchange(pDX);
	DDX_Control(pDX, IDC_EDIT_PROTOCOL, m_EditProtocol);
	DDX_Control(pDX, IDC_COMBO_PROTOCOLLIST, m_CboProtocolList);
	DDX_Control(pDX, IDC_COMBO_SMTP_LOGON_MODE, m_cboEmailMode);
	DDX_Control(pDX, IDC_COMBO_SMTP_ENCRY_MODE, m_cboEncyptType);
}


BEGIN_MESSAGE_MAP(CPageSettingProtocol, CDialog)
	ON_BN_CLICKED(IDC_BUTTON_BROSE, &CPageSettingProtocol::OnBnClickedButtonBrose)
	ON_BN_CLICKED(IDC_BUTTON_UPGRADE, &CPageSettingProtocol::OnBnClickedButtonUpgrade)
	ON_BN_CLICKED(IDC_BUTTON_DELETE, &CPageSettingProtocol::OnBnClickedButtonDelete)
END_MESSAGE_MAP()


// CPageSettingProtocol message handlers

void  CPageSettingProtocol::LoadSurfaceResource()
{
	SetDlgItemText(IDC_STATIC_SETPROTOCOL, GetText(IDS_SETTING_GRPPROTOCOL));
	SetDlgItemText(IDC_STATIC_PROTOCOL, GetText(IDS_SETTING_PROTOCOLPATH));
	SetDlgItemText(IDC_BUTTON_BROSE, GetText(IDS_SETTING_BROWSEPTZ));
	SetDlgItemText(IDC_BUTTON_UPGRADE, GetText(IDS_SETTING_UPGRADEPTZ));
	SetDlgItemText(IDC_STATIC_PROTOCOLLIST, GetText(IDS_SETTING_PROTOCOLLIST));
	SetDlgItemText(IDC_BUTTON_DELETE, GetText(IDS_SETTING_DELETEPTZ));

	SetDlgItemText(IDC_EDIT_SMTP_SERVER, "0");
	SetDlgItemInt(IDC_EDIT_SMTP_PORT, 0);
	SetDlgItemText(IDC_EDIT_SMTP_ACCOUNT, "0");
	SetDlgItemText(IDC_EDIT_SMTP_PASSWORD, "0");
	SetDlgItemText(IDC_EDIT_SMTP_MAIN_TITLE, "0");
	SetDlgItemText(IDC_EDIT_SMTP_RECVADDRESS, "0");
	m_cboEmailMode.AddString(_T("off"));
	m_cboEmailMode.AddString(_T("plain"));
	m_cboEmailMode.AddString(_T("cram-md5"));
	m_cboEmailMode.AddString(_T("digest-md5"));
	m_cboEmailMode.AddString(_T("gssapi"));
	m_cboEmailMode.AddString(_T("external"));
	m_cboEmailMode.AddString(_T("login"));
	m_cboEmailMode.AddString(_T("ntlm"));
	m_cboEmailMode.SetCurSel(0);

	m_cboEncyptType.AddString("");
	m_cboEncyptType.AddString("SSL");
	m_cboEncyptType.AddString("TLS");
	m_cboEncyptType.SetCurSel(0);
}

int CPageSettingProtocol::Initialize(TDECPARAM* _pdecParam)
{
	//ȡЭб
	LoadSurfaceResource();
	//TDECPROTOCOL protocol;
	//memset(&protocol,0,sizeof(TDECPROTOCOL));
	TDECPROTOCOL_EX tProtocolEx = {0};
	int iRet = DEC_ClientGetDevConfig(m_lLogonID, 0, 0, CMD_DEC_CFG_PROTOCOL, &tProtocolEx, sizeof(TDECPROTOCOL_EX));
	if(iRet == 0)
	{
		for(int i=0;i<tProtocolEx.m_iCount;i++)
		{
			m_CboProtocolList.AddString((LPCTSTR)tProtocolEx.m_cProtocol[i]);
		}
	}
	m_CboProtocolList.SetCurSel(0);
    return 0;
}

void CPageSettingProtocol::OnBnClickedButtonBrose()
{
// 	CFileDialog dlgFile(TRUE, NULL, NULL, NULL, _T("Protocol update files (*.so)|*.so||"));
// 	CString fileName;
// 	const int c_cMaxFiles = 255;
// 	const int c_cbBuffSize = (c_cMaxFiles * (MAX_PATH + 1)) + 1;
// 	dlgFile.GetOFN().lpstrFile = fileName.GetBuffer(c_cbBuffSize);
// 	dlgFile.GetOFN().nMaxFile = c_cMaxFiles;
// 
// 	if (IDOK == dlgFile.DoModal())
// 	{
// 		 m_EditProtocol.SetWindowText(fileName); 	
// 	}
// 	fileName.ReleaseBuffer();	

	CFileDialog dlgFile(TRUE, NULL, NULL
		, OFN_FILEMUSTEXIST | OFN_HIDEREADONLY | OFN_ENABLESIZING
		, _T("Protocol update files (*.so)|*.so||"));
	if(IDOK == dlgFile.DoModal())
	{
		CString fileName = dlgFile.GetPathName();
		m_EditProtocol.SetWindowText(fileName); 	
	}
}

void CPageSettingProtocol::OnBnClickedButtonUpgrade()
{
	if (MessageBox(GetText(IDS_SETTING_CONFIRMUPDATE), _T(""), MB_OKCANCEL + MB_ICONQUESTION) == IDOK)
	{
		int iRet;
		CString szFile;
		GetDlgItem(IDC_EDIT_PROTOCOL)->GetWindowText(szFile);
        if (szFile.Compare(_T("")) == 0)
        {
			return;
        }
		iRet = DEC_ClientUpgradeProtocol(m_lLogonID,"protocol",(LPSTR)(LPCTSTR)szFile);
		if(iRet == 0)
		{
			m_dlgUpgrade.DoModal();
		}
		else if(iRet == -7)
		{
			MessageBox(GetText(IDS_SETTING_INVALIDFILE),_T(""),MB_OK|MB_TOPMOST);
		}
		else
		{
			return;
		}
	}
	else
	{
		return;
	}
}

void CPageSettingProtocol::OnBnClickedButtonDelete()
{
	CString strPro;
	m_CboProtocolList.GetLBText(m_CboProtocolList.GetCurSel(), strPro);
	if(_T("DOME_TIANDY") == strPro || _T("DOME_PELCO_P") == strPro || _T("DOME_PELCO_D") == strPro)
	{
		MessageBox(GetText(IDS_SETTING_CANTDELETE),_T(""), MB_OK + MB_ICONWARNING + MB_TOPMOST);
		return;
	}

	if (MessageBox(GetText(IDS_SETTING_CONFIRMDELETEPROTOCOL), _T(""), MB_OKCANCEL + MB_ICONQUESTION) == IDOK)
	{
		CString szProtocol;
		m_CboProtocolList.GetLBText(m_CboProtocolList.GetCurSel(), szProtocol);
		GetDlgItemText(IDC_COMBO_PROTOCOLLIST,szProtocol);
		GetDlgItem(IDC_COMBO_PROTOCOLLIST)->GetWindowText(szProtocol);
		if (szProtocol.Compare(_T("")) == 0)
			return;

		if(DEC_ClientDeleteProtocol(m_lLogonID, (LPSTR)(LPCTSTR)szProtocol)==0)
		{
			int i = m_CboProtocolList.GetCurSel();
			m_CboProtocolList.DeleteString(i);
            m_CboProtocolList.SetCurSel(0);
		}
	}
}

void CPageSettingProtocol::RecvUpdateMsg()
{
	if (m_dlgUpgrade.m_hWnd)
	{
		m_dlgUpgrade.EndDialog(0);
	}   
}


BOOL CPageSettingProtocol::PreTranslateMessage(MSG* pMsg)
{
	if(pMsg->message == WM_KEYDOWN && (pMsg->wParam == VK_RETURN||pMsg->wParam == VK_ESCAPE)) 
	{ 
		return true;
	}

	return CDialog::PreTranslateMessage(pMsg);
}
